#include <pwm.h>
#include <p30fxxxx.h>

/* PWM1-3 are defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/***********************************************************************
* Function Name     : CloseMCPWM
* Description       : This function Clears the Interrupt enable ,flag 
*                     bits, PTCON, PWMCON1 and PWMCON2 registers. 
* Parameters        : void
* Return Value      : void 
**********************************************************************/

void CloseMCPWM(void)
{
    /* clear the Interrupt enables */
    IEC2bits.PWMIE = 0;	
    IEC2bits.FLTAIE = 0;	

#if defined(__dsPIC30F6010a2__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)
    IEC2bits.FLTBIE = 0;	
#endif

    /* clear the Interrupt flags */
    IFS2bits.PWMIF = 0;	
    IFS2bits.FLTAIF = 0;	

#if defined(__dsPIC30F6010a2__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)
    IFS2bits.FLTBIF = 0;	
#endif

    /* clear the PWM control registers */
    PTCON       =       0;
    PWMCON1     =       0;
    PWMCON2     =       0;
}


#endif
